Attribute VB_Name = "Feature"
'	This is a part of the source code for Pro/DESKTOP.
'	Copyright (C) 1999 Parametric Technology Corporation.
'	All rights reserved.


Function menuCreateExtrusion()

If prod Is Nothing Then
    MsgBox "Could not get the application", vbExclamation, "Error"
    Exit Function
End If

'Take the helm
Dim api As helm
Set api = prod.TakeHelm

On Error GoTo NoDocErr

Dim activePart As PartDocument
Set activePart = prod.GetActiveDoc()

On Error GoTo 0

Dim ActiveWorkplane As aWorkplane
Set ActiveWorkplane = activePart.GetActiveWorkplane
If ActiveWorkplane Is Nothing Then
    MsgBox "Could not get the Active Workplane ", vbExclamation, "Error"
    Exit Function
End If

Dim activeSketch As aSketch
Set activeSketch = activePart.GetActiveSketch()

If activeSketch Is Nothing Then
    MsgBox "Could not get the Active Sketch ", vbExclamation, "Error"
    Exit Function
End If

Dim extrusion1 As aExtrusion
Set extrusion1 = cfobject.CreateExtrusion(activeSketch, 0.1, 0, 0, 0, 1, "demoExtrusion" & CStr(extrusionCount), False)

If extrusion1 Is Nothing Then
    MsgBox "CreateExtrusion Failed ", vbExclamation, "Error"
    Exit Function
End If

api.CommitCalls "CreateExtrusion", pause

Exit Function

NoDocErr:
        MsgBox "Could not get the Active Part", vbExclamation, "Error"
        Exit Function



End Function


Function menuCreateProjection()

If prod Is Nothing Then
    MsgBox "Could not get the application", vbExclamation, "Error"
    Exit Function
End If

'Take the helm
Dim api As helm
Set api = prod.TakeHelm

On Error GoTo NoDocErr

Dim activePart As PartDocument
Set activePart = prod.GetActiveDoc()

On Error GoTo 0

Dim Design As aDesign
Set Design = activePart.GetDesign

If Design Is Nothing Then
    MsgBox "Could not get the design ", vbExclamation, "Error"
    Exit Function
End If

Dim bContainsSolid As Boolean
bContainsSolid = Design.ContainsSolids(True)
If (bContainsSolid = False) Then
    MsgBox "The design does not contain a solid ", vbExclamation, "Error"
    Exit Function
End If


Dim ActiveWorkplane As aWorkplane
Set ActiveWorkplane = activePart.GetActiveWorkplane

If ActiveWorkplane Is Nothing Then
    MsgBox "Could not get the Active Workplane ", vbExclamation, "Error"
    Exit Function
End If

Dim activeSketch As aSketch
Set activeSketch = activePart.GetActiveSketch()

If activeSketch Is Nothing Then
    MsgBox "Could not get the Active Sketch ", vbExclamation, "Error"
    Exit Function
End If

Dim FaceSet As ObjectSet
Set FaceSet = prod.GetClass("ObjectSet").CreateAObjectSet

Dim projection3 As aProjection
Set projection3 = cfobject.CreateProjection(activeSketch, FaceSet, 1, 1, 0, 0, 2, "testProjetionCon", False)

api.CommitCalls "CreateProjection", pause

Exit Function

NoDocErr:
        MsgBox "Could not get the Active Part", vbExclamation, "Error"
        Exit Function

End Function


Function menuCreateRevolution()

If prod Is Nothing Then
    MsgBox "Could not get the application", vbExclamation, "Error"
    Exit Function
End If

'Take the helm
Dim api As helm
Set api = prod.TakeHelm

Dim part As PartDocument

Set part = prod.NewPart()
Set centerpoint = prod.GetClass("Vector").CreateVector(-0.11, 0.02, 0)

Dim wp As aWorkplane
Dim plane As zPlane
Set wp = part.GetActiveWorkplane
Set plane = wp.GetGeometry

Dim sk As aSketch
Set sk = part.GetActiveSketch
Dim curve As zCurve
Set curve = prod.GetClass("BasicCircle").CreateBasicCircle(centerpoint, plane.GetNormal, 0.04)
Dim line As aLine
Set line = sk.CreateLine(curve)

Dim Sketch As aSketch
Set Sketch = wp.CreateSketch("axisSketch")
part.SetActiveSketch Sketch

Set vector1 = prod.GetClass("Vector").CreateVector(0, -0.18, 0#)
Set vector2 = prod.GetClass("Vector").CreateVector(0, 0.215, 0#)
Set curve1 = prod.GetClass("BasicStraight").CreateBasicStraightTwoPoints(vector1, vector2)
Set line1 = Sketch.CreateLine(curve1)

Dim FeatureRevolve As aRevolution
Set FeatureRevolve = cfobject.CreateRevolution(sk, Sketch, 6.28, 0, 0, 1, "testRevConFunc", False)

api.CommitCalls "CreateRevolution", pause

Exit Function

NoDocErr:
        MsgBox "Could not get the Active Part", vbExclamation, "Error"
        Exit Function

End Function

Function menuCreateSweep()

If prod Is Nothing Then
    MsgBox "Could not get the application", vbExclamation, "Error"
    Exit Function
End If

'Take the helm
Dim api As helm
Set api = prod.TakeHelm

Dim part As PartDocument
Set part = prod.NewPart

Set centerpoint = prod.GetClass("Vector").CreateVector(-0.11, 0.02, 0)

Dim wp As aWorkplane
Dim plane As zPlane

Set wp = part.GetActiveWorkplane
Set plane = wp.GetGeometry

Dim sk As aSketch
Set sk = part.GetActiveSketch

Dim curve As zCurve
Set curve = prod.GetClass("BasicCircle").CreateBasicCircle(centerpoint, plane.GetNormal, 0.04)

Dim line As aLine
Set line = sk.CreateLine(curve)

Dim curve100 As zCurve
Set curve100 = prod.GetClass("BasicCircle").CreateBasicCircle(centerpoint, plane.GetNormal, 0.025)

Dim line100 As aLine
Set line100 = sk.CreateLine(curve100)

Dim Design As aDesign
Set Design = part.GetDesign

Dim Workplaneset As ObjectSet
Set Workplaneset = Design.GetWorkplanes

Dim wp2 As aWorkplane
Set wp2 = part.LookupWorkplane("frontal")

Dim Sketch As aSketch
Set Sketch = wp2.CreateSketch("Sketch")
part.SetActiveSketch Sketch

Set vector1 = prod.GetClass("Vector").CreateVector(0, 0, 0#)
Set vector2 = prod.GetClass("Vector").CreateVector(0, 0, 0.117)
Set vector3 = prod.GetClass("Vector").CreateVector(0.003, 0, 0.12)
Set vector4 = prod.GetClass("Vector").CreateVector(0.11, 0, 0.12)
Set vector5 = prod.GetClass("Vector").CreateVector(0.003, 0, 0.117)

Set curve1 = prod.GetClass("BasicStraight").CreateBasicStraightTwoPoints(vector1, vector2)
Set line1 = Sketch.CreateLine(curve1)

Dim curve2 As zBasicCircularArc
Dim plane1 As zPlane
Set plane1 = part.GetActiveWorkplane.GetGeometry
Set curve2 = prod.GetClass("BasicCircularArc").CreateBasicCircularArc(vector5, plane1.GetNormal, 0.003, vector3, vector2)

Dim circle1 As aLine
Set circle1 = part.GetActiveSketch.CreateLine(curve2)

Set curve3 = prod.GetClass("BasicStraight").CreateBasicStraightTwoPoints(vector3, vector4)
Set line3 = Sketch.CreateLine(curve3)

Dim FeatureSweep As aOperation
Set FeatureSweep = cfobject.CreateSweep(sk, Sketch, 0, 1, "sweep", False)

api.CommitCalls "CreateSweep", pause

Exit Function

NoDocErr:
        MsgBox "Could not get the Active Part", vbExclamation, "Error"
        Exit Function

End Function

Function menuCreateBlend()

If prod Is Nothing Then
    MsgBox "Could not get the application", vbExclamation, "Error"
    Exit Function
End If

'Take the helm
Dim api As helm
Set api = prod.TakeHelm

On Error GoTo NoDocErr

Dim activePart As PartDocument
Set activePart = prod.GetActiveDoc()

On Error GoTo 0

Dim Design As aDesign
Set Design = activePart.GetDesign
If Design Is Nothing Then
    MsgBox "Could not get the design ", vbExclamation, "Error"
    Exit Function
End If

Dim edgeSet As ObjectSet
Set edgeSet = activePart.GetSelection("Edge")

Dim bIsEmpty As Boolean
bIsEmpty = edgeSet.IsEmpty
If bIsEmpty Then
    MsgBox "No Edges Selected", vbExclamation, "Error"
    Exit Function
End If

If (edgeSet.GetAnyMember.IsA("Edge")) Then

    Dim blend1 As aBlend
    Set blend1 = cfobject.CreateBlend(edgeSet, False, 0, 0.005, 0, "blend" & CStr(blendCount))
    blendCount = blendCount + 1
    Dim flagUpdateDesign As Boolean
    flagUpdateDesign = activePart.GetDesign.NeedsRegenerating

    If flagUpdateDesign Then
        activePart.UpdateDesign
    End If
    
Else
    MsgBox "Entities selected are not Edges"
Exit Function
End If

api.CommitCalls "CreateBlend", pause

Exit Function

NoDocErr:
        MsgBox "Could not get the Active Part", vbExclamation, "Error"
        Exit Function

End Function

Function menuCreateHole()

If prod Is Nothing Then
    MsgBox "Could not get the application", vbExclamation, "Error"
    Exit Function
End If

'Take the helm
Dim api As helm
Set api = prod.TakeHelm

On Error GoTo NoDocErr

Dim activePart As PartDocument
Set activePart = prod.GetActiveDoc()

On Error GoTo 0

Dim Design As aDesign
Set Design = activePart.GetDesign

If Design Is Nothing Then
    MsgBox "Could not get the design ", vbExclamation, "Error"
    Exit Function
End If

Dim bContainsSolid As Boolean
bContainsSolid = Design.ContainsSolids(True)
If (bContainsSolid = False) Then
    MsgBox "The design does not contain a solid ", vbExclamation, "Error"
    Exit Function
End If


Dim ActiveWorkplane As aWorkplane
Set ActiveWorkplane = activePart.GetActiveWorkplane

If ActiveWorkplane Is Nothing Then
    MsgBox "Could not get the Active Workplane ", vbExclamation, "Error"
    Exit Function
End If

Dim activeSketch As aSketch
Set activeSketch = activePart.GetActiveSketch()

If activeSketch Is Nothing Then
    MsgBox "Could not get the Active Sketch ", vbExclamation, "Error"
    Exit Function
End If

Dim FaceSet As ObjectSet
Set FaceSet = prod.GetClass("ObjectSet").CreateAObjectSet()

Dim hole As aHole
Set hole = cfobject.CreateHole(activeSketch, FaceSet, 1, 0, 1, 0.03, 0, 0, 0, 0, 0, 0, "demoHole" & CStr(holeCount))

api.CommitCalls "CreateHole", pause

Exit Function

NoDocErr:
        MsgBox "Could not get the Active Part", vbExclamation, "Error"
        Exit Function

End Function

Function menuCreateHollow()

If prod Is Nothing Then
    MsgBox "Could not get the application", vbExclamation, "Error"
    Exit Function
End If

'Take the helm
Dim api As helm
Set api = prod.TakeHelm

On Error GoTo NoDocErr

Dim activePart As PartDocument
Set activePart = prod.GetActiveDoc()

On Error GoTo 0

Dim Design As aDesign
Set Design = activePart.GetDesign

If Design Is Nothing Then
    MsgBox "Could not get the design ", vbExclamation, "Error"
    Exit Function
End If

Dim bContainsSolid As Boolean
bContainsSolid = Design.ContainsSolids(True)
If (bContainsSolid = False) Then
    MsgBox "The design does not contain a solid ", vbExclamation, "Error"
    Exit Function
End If


Dim ActiveWorkplane As aWorkplane
Set ActiveWorkplane = activePart.GetActiveWorkplane

If ActiveWorkplane Is Nothing Then
    MsgBox "Could not get the Active Workplane ", vbExclamation, "Error"
    Exit Function
End If

Dim activeSketch As aSketch
Set activeSketch = activePart.GetActiveSketch()

If activeSketch Is Nothing Then
    MsgBox "Could not get the Active Sketch ", vbExclamation, "Error"
    Exit Function
End If

Dim FaceSet As ObjectSet
Set FaceSet = activePart.GetSelection("Face")

If (FaceSet.IsEmpty) Then
    MsgBox "Faces not Selected"
    Exit Function
End If

If (FaceSet.GetAnyMember.IsA("Face")) Then
    
    Dim Hollow1 As aOperation
    Set Hollow1 = cfobject.CreateHollow(FaceSet, 0.005, "demoHollowc" & CStr(hollowCount))
    hollowCount = hollowCount + 1

Else
MsgBox "Entities selected are not Faces"
End If

api.CommitCalls "CreateHollow", pause

Exit Function

NoDocErr:
        MsgBox "Could not get the Active Part", vbExclamation, "Error"
        Exit Function

End Function

Function menuUseComponent()

If prod Is Nothing Then
    MsgBox "Could not get the application", vbExclamation, "Error"
    Exit Function
End If

'Take the helm
Dim api As helm
Set api = prod.TakeHelm

On Error GoTo NoDocErr

Dim activePart As PartDocument
Set activePart = prod.GetActiveDoc()

On Error GoTo 0

Dim componentSet As ObjectSet
Set componentSet = activePart.GetSelection("DesignInstance")

If (componentSet.IsEmpty) Then
    MsgBox ("No Component is Selected")
    Exit Function
End If

Dim componentSetIt As iterator
Set componentSetIt = prod.GetClass("It").CreateAObjectIt(componentSet)

If (componentSet.GetAnyMember.IsA("DesignInstance")) Then

    If (componentSet.GetCount = 1) Then

        Dim op As aOperation
        Set op = cfobject.UseComponent(componentSetIt.start, 1, True, "demoTool" & CStr(componentcount))
    Else
    MsgBox "More than One Component Selected"
    Exit Function
    End If

Else
MsgBox "The Operation cannot be performed on the Selected entity"
Exit Function
End If

Dim flagUpdateDesign As Boolean
flagUpdateDesign = activePart.GetDesign.NeedsRegenerating

If flagUpdateDesign Then
    activePart.UpdateDesign
End If

api.CommitCalls "UseComponent", pause

Exit Function

NoDocErr:
        MsgBox "Could not get the Active Part", vbExclamation, "Error"
        Exit Function

End Function

Function menuUncondemnAll()

If prod Is Nothing Then
    MsgBox "Could not get the application", vbExclamation, "Error"
    Exit Function
End If


'Take the helm
Dim api As helm
Set api = prod.TakeHelm

On Error GoTo NoDocErr

Dim activePart As PartDocument
Set activePart = prod.GetActiveDoc()

On Error GoTo 0


'Get the design
Dim Design As aDesign
Set Design = activePart.GetDesign
If Design Is Nothing Then
    MsgBox "Could not get the design ", vbExclamation, "Error"
    Exit Function
End If

'Get the number of operations in a design
Dim n As Integer
n = Design.GetOperationCount


Dim bIsCondemned As Boolean
For I = 0 To n - 1
    bIsCondemned = Design.GetOperation(I).IsCondemned
    If (bIsCondemned = False) Then
        GoTo 100
    End If

    If (bIsCondemned) Then
        cfobject.UncondemnAll
    End If

100:
Next I

'activePart.Update 10

api.CommitCalls "UncondemnAll", pause

Exit Function

NoDocErr:
        MsgBox "Could not get the Active Part", vbExclamation, "Error"
        Exit Function

End Function


Function menuUpdateDesign()

If prod Is Nothing Then
    MsgBox "Could not get the application", vbExclamation, "Error"
    Exit Function
End If

'Take the helm
Dim api As helm
Set api = prod.TakeHelm

On Error GoTo NoDocErr

Dim activePart As PartDocument
Set activePart = prod.GetActiveDoc()

On Error GoTo 0


'Get the design
Dim Design As aDesign
Set Design = activePart.GetDesign
If Design Is Nothing Then
    MsgBox "Could not get the design ", vbExclamation, "Error"
    Exit Function
End If

Dim flagUpdateDesign As Boolean
flagUpdateDesign = Design.NeedsRegenerating

If flagUpdateDesign Then
    cfobject.UpdateDesign
End If

api.CommitCalls "UpdateDesign", pause

Exit Function

NoDocErr:
        MsgBox "Could not get the Active Part", vbExclamation, "Error"
        Exit Function

End Function







